/*
 * Decompiled with CFR 0.152.
 */
import processing.core.PApplet;
import processing.core.PImage;
import processing.video.Movie;

public class VideoScratcher
extends PApplet {
    boolean flip;
    Movie myMovie;
    Movie myMovieA;
    float placeStart;
    float placeStop;
    float speed;
    int screenSizeX;
    int screenSizeY;
    float[] places = new float[5];
    PImage[] placeI = new PImage[5];
    int guideWidth;
    int heightGuide;

    public void setup() {
        this.screenSizeX = 320;
        this.screenSizeY = 288;
        this.size(320, 288, "processing.core.PGraphics3D");
        this.background(0);
        this.DoMovieSetup("ShortStreet.mov");
    }

    public void DoMovieSetup(String string) {
        this.placeStart = 0.0f;
        this.placeStop = 0.5f;
        this.myMovieA = new Movie((PApplet)this, string);
        this.myMovieA.loop();
        this.flip = true;
        this.speed = 1.0f;
        float f = this.myMovieA.duration();
        this.places[0] = 0.0f;
        this.places[1] = 1.0f * f / 5.0f;
        this.places[2] = 2.0f * f / 5.0f;
        this.places[3] = 3.0f * f / 5.0f;
        this.places[4] = 4.0f * f / 5.0f;
        VideoScratcher.println((float)this.places[0]);
        VideoScratcher.println((float)this.places[1]);
        VideoScratcher.println((float)this.places[2]);
        VideoScratcher.println((float)this.places[3]);
        VideoScratcher.println((float)this.places[4]);
        this.guideWidth = this.screenSizeX / 5;
        this.heightGuide = this.screenSizeY - this.screenSizeY / 5;
        this.placeI[0] = this.loadImage("0.jpg");
        this.placeI[1] = this.loadImage("1.jpg");
        this.placeI[2] = this.loadImage("2.jpg");
        this.placeI[3] = this.loadImage("3.jpg");
        this.placeI[4] = this.loadImage("4.jpg");
    }

    public void movieEvent(Movie movie) {
        movie.read();
    }

    public void draw() {
        this.image((PImage)this.myMovieA, 0.0f, 0.0f, this.screenSizeX, this.screenSizeY);
        if (!this.flip) {
            if (this.myMovieA.time() >= this.placeStop) {
                this.myMovieA.jump(this.placeStart);
            }
        } else if (this.speed > 0.0f) {
            if (this.myMovieA.time() >= this.placeStop) {
                this.myMovieA.speed(-this.speed);
            }
            if (this.myMovieA.time() <= this.placeStart) {
                this.myMovieA.speed(this.speed);
            }
        } else {
            if (this.myMovieA.time() >= this.placeStop) {
                this.myMovieA.speed(this.speed);
            }
            if (this.myMovieA.time() <= this.placeStart) {
                this.myMovieA.speed(-this.speed);
            }
        }
        this.image(this.placeI[0], 0.0f, this.heightGuide, this.screenSizeX / 5, this.screenSizeY / 5);
        this.image(this.placeI[1], 1 * this.guideWidth, this.heightGuide, this.screenSizeX / 5, this.screenSizeY / 5);
        this.image(this.placeI[2], 2 * this.guideWidth, this.heightGuide, this.screenSizeX / 5, this.screenSizeY / 5);
        this.image(this.placeI[3], 3 * this.guideWidth, this.heightGuide, this.screenSizeX / 5, this.screenSizeY / 5);
        this.image(this.placeI[4], 4 * this.guideWidth, this.heightGuide, this.screenSizeX / 5, this.screenSizeY / 5);
    }

    public void mousePressed() {
        float f = (float)this.mouseX * this.myMovieA.duration();
        this.placeStart = f / (float)this.screenSizeX;
        float f2 = this.mouseY * 100;
        f2 /= (float)this.screenSizeY;
        int n = PApplet.parseInt((float)(f2 *= 2.0f));
        this.speed = f2 = PApplet.parseFloat((int)n) / 100.0f;
    }

    public void mouseReleased() {
        float f = (float)this.mouseX * this.myMovieA.duration();
        this.placeStop = f / (float)this.screenSizeX;
        this.myMovieA.jump(this.placeStart);
        this.myMovieA.speed(this.speed);
    }

    public static void main(String[] stringArray) {
        PApplet.main((String[])new String[]{"--bgcolor=#ffffff", "VideoScratcher"});
    }
}

